using System;
using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using gov.va.med.vbecs.ExceptionManagement;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{

		#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>9/3/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///	Data access component providing database read/write access
	///	to product Shipper related data.
	///</summary>

		#endregion

	public class ProductShipper
	{

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="649"> 
		///		<ExpectedInput>BloodProductGuid and division code</ExpectedInput>
		///		<ExpectedOutput>DataTable of product Shippers for a product</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1926"> 
		///		<ExpectedInput>Empty Guid</ExpectedInput>
		///		<ExpectedOutput>DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///	Retrieves an active product shippers data for a given blood product
		/// </summary>
		/// <param name="bloodProductGuid">Blood product GUID</param>
		/// <returns>DataTable of active product Shippers for a blood product</returns>
		public static DataTable GetProductShippersByDivision(System.Guid bloodProductGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetProductShippersByDivision.bloodproductguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetProductShippersByDivision.divisioncode, System.Data.SqlDbType.Char),

			};
			if(bloodProductGuid == System.Guid.Empty)
			{
				prms[0].Value = DBNull.Value;
			}
			else
			{
				prms[0].Value = bloodProductGuid;
			}
			prms[1].Value = Common.LogonUser.LogonUserDivisionCode;
			
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetProductShippersByDivision.StoredProcName, prms);

			return ds.Tables[0];
		}
		

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1257"> 
		///		<ExpectedInput>ProductShipperGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable of ProductShipper data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1261"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetProductShipperByGUID
		/// </summary>
		/// <param name="productShipperGuid">ProductShipperGuid</param>
		/// <returns>Data Table</returns>
		public static DataTable GetProductShipperByGuid(System.Guid productShipperGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetProductShipperByGuid.productshipperguid, System.Data.SqlDbType.UniqueIdentifier)
			};

			prms[0].Value = productShipperGuid;
			
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetProductShipperByGuid.StoredProcName, prms);
			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>Greg</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/27/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="6632"> 
		///		<ExpectedInput>Valid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="6633"> 
		///		<ExpectedInput>Invalid Parameters</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetProductShipperByGUID
		///</summary>
		/// <param name="bloodProductGuid"></param>
		/// <param name="localSupplierGuid"></param>
		/// <returns></returns>
		public static DataTable GetProductShipperByLocalSupplier(System.Guid bloodProductGuid, System.Guid localSupplierGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetProductShipperByLocalSupplierDivision.bloodproductguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetProductShipperByLocalSupplierDivision.localsupplierguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetProductShipperByLocalSupplierDivision.divisioncode, System.Data.SqlDbType.Char)
			};

			prms[0].Value = bloodProductGuid;
			prms[1].Value = localSupplierGuid;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;
			
			DataSet ds = Common.StoredProcedure.GetData(STOREDPROC.GetProductShipperByLocalSupplierDivision.StoredProcName, prms);
			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1269"> 
		///		<ExpectedInput>LocalSupplierGuid</ExpectedInput>
		///		<ExpectedOutput>DataTable of Suplier data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1270"> 
		///		<ExpectedInput>Invalid Guid</ExpectedInput>
		///		<ExpectedOutput>Empty DataTable</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// GetProductShipperFacilityName
		/// </summary>
		/// <param name="localSupplierGuid"></param>
		/// <returns></returns>
		public static DataTable GetProductShipperFacilityName(System.Guid localSupplierGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetProductShipperFacilityDetails.localsupplierguid, System.Data.SqlDbType.UniqueIdentifier)
			};

			prms[0].Value = localSupplierGuid;

			DataSet ds = Common.StoredProcedure.GetData(Common.VbecsStoredProcs.GetProductShipperFacilityDetails.StoredProcName, prms);
			return ds.Tables[0];

		}

		///<Developers>
		///	<Developer>Carrie Van Stedum</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3071"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Data table</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1264"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		///	Retrieves an active product shipper data for a given division
		/// </summary>
		/// <returns>DataTable of active product Shippers for a division</returns>
		/// 
		public static DataTable GetProductShippersByDivisionLookUpList()
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetProductShippersByDivisionLookUpList.divisioncode, System.Data.SqlDbType.Char)
			};
			
			prms[0].Value = Common.LogonUser.LogonUserDivisionCode;

			DataSet	ds = Common.StoredProcedure.GetData(STOREDPROC.GetProductShippersByDivisionLookUpList.StoredProcName, prms);
			return ds.Tables[0];
		}

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/30/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5708"> 
		///		<ExpectedInput>BloodProductGuid, LocalSupplierGuid</ExpectedInput>
		///		<ExpectedOutput>decimal</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5709"> 
		///		<ExpectedInput>Invalid parameters</ExpectedInput>
		///		<ExpectedOutput>DataAccessLayer Exception</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetReimbursementPercentage
		/// </summary>
		/// <param name="localSupplierGuid"></param>
		/// <param name="bloodUnitGuid"></param>
		/// <returns></returns>
		public static decimal GetReimbursementPercentage(Guid bloodUnitGuid, Guid localSupplierGuid)
		{
			SqlParameter[] prms =
			{
				new SqlParameter(STOREDPROC.GetReimbursementPercentage.bloodunitguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetReimbursementPercentage.localsupplierguid, System.Data.SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetReimbursementPercentage.divisioncode, System.Data.SqlDbType.Char)
			};
			
			prms[0].Value = bloodUnitGuid;		//CR1864 - changed from BPGuid to BUGuid
			prms[1].Value = localSupplierGuid;
			prms[2].Value = Common.LogonUser.LogonUserDivisionCode;

			DataTable dtResults = Common.StoredProcedure.GetData(STOREDPROC.GetReimbursementPercentage.StoredProcName, prms).Tables[0];
			if (dtResults.Rows.Count < 1 || dtResults.Rows.Count > 1)
			{
				throw new DataAccessLayerException("Product shipper information not found.  Please contact your system administrator.");
			}
			else
			{
				return (decimal) Convert.ToDecimal(dtResults.Rows[0][0]);
				//return 0;
			}

		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>7/13/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="1265"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>Empty ProductShipper Table Schema</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="1266"> 
		///		<ExpectedInput>false</ExpectedInput>
		///		<ExpectedOutput>ProductShipper table without RowVersion</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>	
		/// <summary>
		/// GetEmptyProductShipperTable
		/// </summary>
		/// <param name="isUpdate"></param>
		/// <returns>Data table</returns>
		public static System.Data.DataTable GetEmptyProductShipperTable(bool isUpdate)
		{
			DataTable dt = new System.Data.DataTable(TABLE.ProductShipper.TableName);

			dt.Columns.Add(TABLE.ProductShipper.ProductCost, typeof(System.Decimal));
			dt.Columns.Add(TABLE.ProductShipper.ProductShipperGuid, typeof(System.Guid));
			dt.Columns.Add(TABLE.ProductShipper.RecordStatusCode, typeof(string));
			dt.Columns.Add(TABLE.ProductShipper.ReturnCreditPercentage, typeof(System.Decimal));
			dt.Columns.Add(TABLE.ProductShipper.LastUpdateUser, typeof(string));
			dt.Columns.Add(TABLE.ProductShipper.LastUpdateFunctionId, typeof(int));

			if (isUpdate)
			{
				dt.Columns.Add(TABLE.ProductShipper.RowVersion, typeof(byte[]));
			}
			else
			{
				dt.Columns.Add(TABLE.ProductShipper.BloodProductGuid, typeof(System.Guid));
				dt.Columns.Add(TABLE.ProductShipper.DivisionCode, typeof(string));
				dt.Columns.Add(TABLE.ProductShipper.LocalSupplierGuid, typeof(System.Guid));
			}

			return dt;
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/25/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8097"> 
		///		<ExpectedInput>ProductShipper DataTable</ExpectedInput>
		///		<ExpectedOutput>true</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8098"> 
		///		<ExpectedInput>Invalid DataTable</ExpectedInput>
		///		<ExpectedOutput>UniqueTableConstraint</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// InsertProductShipper
		/// </summary>
		/// <param name="dtProductShipper"></param>
		/// <returns></returns>
		public static bool InsertProductShipper(System.Data.DataTable dtProductShipper)
		{
			int retValue = new StoredProcedure().TransactionalGetValue(STOREDPROC.InsertProductShipper.StoredProcName, dtProductShipper);

			return (retValue == 0);
		}
	}
}


